<?php

class TestOfMemoryCache extends UnitTestCase
{
	public function testDataWrittenToCacheIsRetreivable()
	{
		$cache = new Swift_Cache_Memory();
		$testdata = "abc123";
		$cache->write("test", $testdata);
		$ret = "";
		while(false !== $bytes = $cache->read("test"))
			$ret .= $bytes;
		$this->assertEqual($testdata, $ret);
		
		$testdata = "Happy Go Lucky";
		$cache->write("test2", $testdata);
		$ret = "";
		while(false !== $bytes = $cache->read("test2"))
			$ret .= $bytes;
		$this->assertEqual($testdata, $ret);
	}
	
	public function testCacheOnlyReportsToHaveCachedData()
	{
		$cache = new Swift_Cache_Memory();
		$testdata = "abc123";
		$cache->write("test", $testdata);
		$this->assertTrue($cache->has("test"));
		
		$testdata = "Happy Go Lucky";
		$cache->write("test2", $testdata);
		$this->assertTrue($cache->has("test2"));
		
		$this->assertFalse($cache->has("foobar"));
		
		$cache->write("foobar", "abc");
		$this->assertTrue($cache->has("foobar"));
	}
	
	public function testPutIsABuffer()
	{
		$cache = new Swift_Cache_Memory();
		$cache->write("test", "abc");
		$ret = "";
		while (false !== $bytes = $cache->read("test"))
			$ret .= $bytes;
		$this->assertEqual("abc", $ret);
		$cache->write("test", "def");
		$ret = "";
		while (false !== $bytes = $cache->read("test"))
			$ret .= $bytes;
		$this->assertEqual("abcdef", $ret);
		$cache->write("test", "123");
		$ret = "";
		while (false !== $bytes = $cache->read("test"))
			$ret .= $bytes;
		$this->assertEqual("abcdef123", $ret);
		
	}
	
	public function testCacheKeyCanBeCleared()
	{
		$cache = new Swift_Cache_Memory();
		$cache->write("test", "abc");
		$this->assertTrue($cache->has("test"));
		$cache->clear("test");
		$this->assertFalse($cache->has("test"));
	}
	
	public function testReturnedOutputStreamIsJustAWrapper()
	{
		$cache = new Swift_Cache_Memory();
		$cache->write("test", "abcdefghijklmnopqrstuvwxyz");
		$os = $cache->getOutputStream("test");
		$ret = "";
		while (false !== $bytes = $os->read())
			$ret .= $bytes;
		$this->assertEqual("abcdefghijklmnopqrstuvwxyz", $ret);
	}
}
