<?php

class TestOfFileNameMaker extends UnitTestCase
{
	public function testPrefixIsUsed()
	{
		$name = Swift_FileNameMaker::instance()->generate("prefix");
		$this->assertPattern("/^prefix\\d+/", $name);
		$name = Swift_FileNameMaker::instance()->generate("filename");
		$this->assertPattern("/^filename\\d+/", $name);
		$name = Swift_FileNameMaker::instance()->generate("xxx.yyy.zzz.");
		$this->assertPattern("/^xxx\\.yyy\\.zzz\\.\\d+/", $name);
	}
	
	public function testSequenceNumberIsAlwaysIncremented()
	{
		$name = Swift_FileNameMaker::instance()->generate();
		$id1 = (int) substr($name, -1);
		$name = Swift_FileNameMaker::instance()->generate();
		$id2 = (int) substr($name, -1);
		$this->assertTrue($id2 > $id1);
		$name = Swift_FileNameMaker::instance()->generate();
		$id3 = (int) substr($name, -1);
		$this->assertTrue($id3 > $id2);
	}
}
