<?php

class TestOfEmbeddedFile extends UnitTestCase
{
	public function testFileHasNeededHeaders()
	{
		$file = new Swift_Message_EmbeddedFile("some string");
		$structure = $file->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Disposition: inline;\\s* filename=(\"?).*?\\1\r\n" .
			"Content-ID: <.*?>\r\n\r\n.*~s", $structure);
		
		$file = new Swift_Message_EmbeddedFile(new Swift_File("../files/manchester.jpeg"));
		$structure = $file->build()->readFull();
		$this->assertPattern(
			"~Content-Type: application/octet-stream\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Disposition: inline;\\s* filename=(\"?).*?\\1\r\n" .
			"Content-ID: <.*?>\r\n\r\n.*~s", $structure);
	}
	
	public function testContentIdCanBeSetAndRetreived()
	{
		$file = new Swift_Message_EmbeddedFile("some string", "foo", "image/jpeg", "my_cid");
		$this->assertEqual("my_cid", $file->getContentId());
		$structure = $file->build()->readFull();
		$this->assertPattern(
			"~Content-Type: image/jpeg\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Disposition: inline;\\s* filename=foo\r\n" .
			"Content-ID: <my_cid>\r\n\r\n.*~s", $structure);
		
		$file->setContentId("another_cid");
		$this->assertEqual("another_cid", $file->getContentId());
		$structure = $file->build()->readFull();
		$this->assertPattern(
			"~Content-Type: image/jpeg\r\nContent-Transfer-Encoding: base64\r\n".
			"Content-Disposition: inline;\\s* filename=foo\r\n" .
			"Content-ID: <another_cid>\r\n\r\n.*~s", $structure);
	}
}
