<?php

Mock::Generate("Swift_Connection_Rotator", "MockRotatorConnection");

class TestOfConnectionRotatorPlugin extends UnitTestCase
{
	/** Get a mock connection for testing
	 * @param int The number emails you expect to send
	 * @param Swift_Connection A mocked object which has not been setup yet
	 * @return FullMockConnection
	 */
	protected function getWorkingMockConnection($send=1, $conn=null, $reconnect_at=0, $max_reconnect=0)
	{
		$count = 0;
		if (!$conn) $conn = new FullMockConnection();
		$conn->setReturnValueAt($count++, "read", "220 xxx ESMTP");
		$conn->setReturnValueAt($count++, "read", "250-Hello xxx\r\n250 HELP");
		$cycle = 0;
		$reconnected = 0;
		for ($i = 0; $i < $send; $i++)
		{
			$cycle++;
			$conn->setReturnValueAt($count++, "read", "250 Ok");
			$conn->setReturnValueAt($count++, "read", "250 Ok");
			$conn->setReturnValueAt($count++, "read", "354 Go ahead");
			$conn->setReturnValueAt($count++, "read", "250 Ok");
			if ($reconnect_at && $reconnect_at == $cycle)
			{
				if (!$max_reconnect || $max_reconnect > $reconnected)
				{
					$conn->setReturnValueAt($count++, "read", "220 xxx ESMTP");
					$conn->setReturnValueAt($count++, "read", "250-Hello xxx\r\n250 HELP");
					$cycle = 0;
					$reconnected++;
				}
			}
		}
		$conn->setReturnValue("read", "221 Bye");
		return $conn;
	}
	
	public function testPluginInvokesTheNextConnectionMethod()
	{
		$plugin = new Swift_Plugin_ConnectionRotator();
		$conn = $this->getWorkingMockConnection(5, new MockRotatorConnection(), 1);
		$conn->expectCallCount("nextConnection", 5);
		$conn->setReturnValueAt(0, "getActive", 0);
		$conn->setReturnValueAt(1, "getActive", 1);
		$conn->setReturnValueAt(2, "getActive", 2);
		$conn->setReturnValueAt(3, "getActive", 3);
		$conn->setReturnValueAt(4, "getActive", 4);
		
		$swift = new Swift($conn);
		$swift->attachPlugin(new Swift_Plugin_ConnectionRotator(1), "foo");
		
		for ($i = 0; $i < 5; $i++)
		{
			$swift->send(new Swift_Message("subject", "body"), new Swift_Address("foo@bar.tld"), new Swift_Address("zip@button.com"));
		}
	}
	
	public function testThresholdIsHonouredBeforeRotating()
	{
		$plugin = new Swift_Plugin_ConnectionRotator();
		$conn = $this->getWorkingMockConnection(20, new MockRotatorConnection(), 6, 2);
		$conn->expectCallCount("nextConnection", 3);
		$conn->setReturnValueAt(0, "getActive", 0);
		$conn->setReturnValueAt(1, "getActive", 1);
		$conn->setReturnValueAt(2, "getActive", 2);
		
		$swift = new Swift($conn);
		$swift->attachPlugin(new Swift_Plugin_ConnectionRotator(6), "foo");
		
		for ($i = 0; $i < 20; $i++)
		{
			$swift->send(new Swift_Message("subject", "body"), new Swift_Address("foo@bar.tld"), new Swift_Address("zip@button.com"));
		}
	}
	
	// testAllConnectionsAreClosedWhenDisconnectIsCalled() has been removed.  Already tested in TestOfRotatorConnection
}
