<?php

Mock::Generate("Swift_Authenticator", "MockAuthenticator");
Mock::GeneratePartial("Swift_Connection_SMTP", "PartialSmtpConnection", array("read"));

class TestOfAuthenticator extends UnitTestCase
{
	public function testAuthenticatorIsInvokedIfSMTPUsernameAndPasswordSet()
	{
		try {
			$auth = new MockAuthenticator();
			$auth->setReturnValue("getAuthExtensionName", "FOO");
			$auth->expectOnce("isAuthenticated", array("foo", "bar", "*"));
			$smtp = new PartialSmtpConnection();
			$smtp->setExtension("AUTH", array("FOO"));
			$smtp->setUsername("foo");
			$smtp->setPassword("bar");
			$smtp->attachAuthenticator($auth);
			$smtp->postConnect(new Swift($smtp, "xx", Swift::NO_START));
		} catch (Swift_Connection_Exception $e) {
			//
		}
	}
}
