<?php

class TestOfAddress extends UnitTestCase
{
	public function testAddressIsBuiltInCorrectFormat()
	{
		$address = new Swift_Address("foo@bar.com");
		$this->assertEqual("foo@bar.com", $address->build());
		$address->setName("Foo");
		$this->assertEqual("Foo <foo@bar.com>", $address->build());
		$address->setAddress("joe@bloggs.com");
		$this->assertEqual("Foo <joe@bloggs.com>", $address->build());
		
		$address = new Swift_Address("zip@button.com", "Zip");
		$this->assertEqual("Zip <zip@button.com>", $address->build());
	}
	
	public function testAddressCanBeReturnedForSMTPEnvelope()
	{
		$address = new Swift_Address("foo@bar.xxx", "FooBar");
		$this->assertEqual("<foo@bar.xxx>", $address->build(true));
		
		$address->setAddress("zip@button.com");
		$this->assertEqual("<zip@button.com>", $address->build(true));
	}
}
