<?php
ini_set("memory_limit",-1);
ini_set('max_execution_time', 5000);
class hyper_city_retail
{
		public $aobj_context;
 
		function __construct($aobj_context,$parent_obj)
		{
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->parent_obj=$parent_obj;
		$this->user_id = $_SESSION['user_id'];
		$format_file=$aobj_context->main_src."/src/format.php";
		$this->dec_pat="/^[-+]?[0-9]+\.[0-9]{2}+$/";				
		$this->number_pat="/^[0-9]+$/";		
		}
		function TrimWhiteSpaces($text)
		{
		return trim(preg_replace('/\s\s+/', ' ',$text));
		}
		function ReomveCommas($text)
		{
		return trim(preg_replace('/,/', '',$text));
		}
		function ReomveSpecialChars($text)
		{
		return trim(preg_replace('/[^0-9a-zA-Z-]/', '',$text));
		}
		function getIndexIds($explode_line_arr,$name,$start_index)
		{
			for($i=$start_index;$i<count($explode_line_arr);$i++)
			{
			$cell_val=$explode_line_arr[$i];
			 if (preg_match("/{$name}/", $cell_val))
			 return $i;
			}
		}
		function getIndexIdsWoSpace($explode_line_arr,$name,$start_index)
		{
			for($i=$start_index;$i<count($explode_line_arr);$i++)
			{
			$cell_val=$this->TrimWhiteSpaces($explode_line_arr[$i]);
			// echo $cell_val."<br>";
			 if (preg_match("/{$name}/", $cell_val))
			 return $i;
			}
		}
		function GetFullDateFormat($date)
		{
		return str_ireplace(".","/",$date);
		}
		function Addlast2DigitToDate($str)
		{
			$explode_arr=explode("/",$str);
			$date=$explode_arr[0]."/".$explode_arr[1]."/".substr("20".$explode_arr[2],-4);
			return $date;
		}
		function GetDataTxtFromArrStartToEnd($explode_line_arr,$start_indx,$end_indx)
		{
			$txt="";
			for($i=$start_indx;$i<=$end_indx;$i++)
			{
			$o_txt=trim($explode_line_arr[$i]);
			$txt.="{$o_txt} ";
			}
			return trim($txt);
		}
	
	 	 
		function GetLineStartAndEndDetails($explode_line_arr)
		{
			$indx=$this->getIndexIds($explode_line_arr,"LCF  LCF Description",1);
			$this->start_line_indx=$indx+1;
			$indx=$this->getIndexIds($explode_line_arr,"Sub Total",$this->start_line_indx);
			$this->end_line_indx=$indx-1;
			$this->item_rows_arr=array();
			 for($i=$this->start_line_indx;$i<=$this->end_line_indx;$i++)
			{
				$r_data=trim($explode_line_arr[$i]);
				if(!empty($r_data))
				$this->item_rows_arr[$i]=$explode_line_arr[$i];
			}
			$this->item_rows_arr=array_slice($this->item_rows_arr,0);
			 
			
			//check for LCF  LCF Description keyword for 2/3/4  page 
			for($page=1;$page<3;$page++)
			{
				$indx=$this->getIndexIds($this->item_rows_arr,"LCF  LCF Description",1);
				if($indx>0)
				{
					for($i=8;$i>=0;$i--)//before 8-9
					{
					unset($this->item_rows_arr[$indx-$i]);
					}
					$this->item_rows_arr=array_slice($this->item_rows_arr,0);
				}
			}
			$tmp_arr=$this->item_rows_arr;
			$this->item_rows_arr=array();
			foreach($tmp_arr as $ak=>$av)
			{
			//echo $av."<br>";
				 if (!preg_match("/Cont./", trim($av)))
				 array_push($this->item_rows_arr,$av);
			}
			//$this->item_rows_arr=array_slice($tmp_arr,0);
			// echo "<pre>";print_r($this->item_rows_arr);die();
			 
			
		}
		
		 
		function GetBillingShippingAddress($explode_line_arr)
		{
		$this->shipping_address="";
		$this->billing_address="";
		 
			$index=$this->getIndexIds($explode_line_arr,"Bill To",1)+1;
			$end_index=$this->getIndexIds($explode_line_arr,"Ship To",$index)-1;
			for($i=$index;$i<= $end_index;$i++)
			{
				$row_val=explode("           ",$explode_line_arr[$i]);
				$this->billing_address.=$row_val[0]." ";
				 
			}
			$index=$this->getIndexIds($explode_line_arr,"Ship To",1);
			$end_index=$this->getIndexIds($explode_line_arr,"GST No",$index)-1;
			for($i=$index;$i<= $end_index;$i++)
			{
				$row_val=explode("          ",$explode_line_arr[$i]);
				$this->shipping_address.=$row_val[0]." ";
				 
			}
			 
			$this->final_data['ship_to_address']=$this->TrimWhiteSpaces($this->shipping_address);
			$this->final_data['bill_to_address']=$this->TrimWhiteSpaces($this->billing_address);
			 
			 
		}
		function GetPoNumberAndDate($explode_line_arr)
		{
			 // echo "<pre>";print_r($explode_line_arr);
			$index=$this->getIndexIdsWoSpace($explode_line_arr,"P u r ch as e O rd e r",1);
		 
			$row_data=$explode_line_arr[$index];	
 			
			$po_arr=explode("P u r ch as e O rd e r",$row_data);
			 
			$po_number=trim(str_ireplace("P / O  N u m b e r","",$po_arr[0]));
			$po_number=trim(str_ireplace(":","",$po_number));
			
			$po_arr1=explode("P",$po_number);
		 
			$po_number=$po_arr1[0];
			$this->final_data['po_number']=$this->ReomveSpecialChars($po_number);
			
			if(empty($this->final_data['po_number']))
			{
				$index=$this->getIndexIdsWoSpace($explode_line_arr,"Location",1);
		 
			$row_data=$explode_line_arr[$index-1];	
 		 
			$po_arr=explode("P u r c h a s e  O r d e r",$row_data);
			 
			$po_number=trim(str_ireplace("P / O  N u m b e r","",$po_arr[0]));
			$po_number=trim(str_ireplace(":","",$po_number));
			
			$po_arr1=explode("P",$po_number);
		 
			$po_number=$po_arr1[0];
			$this->final_data['po_number']=$this->ReomveSpecialChars($po_number);
			}
			
			if(empty($this->final_data['po_number']))
			{
				$index=$this->getIndexIdsWoSpace($explode_line_arr,"Location",1);
		 
			$row_data=strtolower($explode_line_arr[$index-1]);	
			
			$po_arr=explode("p u r c h a s e  o r d e r",$row_data);
			 
			$po_number=trim(str_ireplace("p / o  n u m b e r","",$po_arr[0]));
			$po_number=trim(str_ireplace(":","",$po_number));
			
			$po_arr1=explode("pu",$po_number);
		 
			$po_number=$po_arr1[0];
			$po_number=trim(str_ireplace("[a-z]","",$po_number));
			$exp_arr=explode("r",$po_number);
			$po_number=$exp_arr[1];
			$this->final_data['po_number']=$this->ReomveSpecialChars($po_number);
			}
			
			
			$index=$this->getIndexIds($explode_line_arr,"Entry Date",2);	
			$row_data=$explode_line_arr[$index];	
			$date_arr=explode("Entry Date",$row_data);
			$po_date=trim(str_ireplace("-","",$date_arr[1]));
			 
			$index=$this->getIndexIds($explode_line_arr,"Ship Date",2);	
			$row_data=$explode_line_arr[$index];	
			$date_arr=explode("Ship Date",$row_data);
			$ship_date=trim(str_ireplace("-","",$date_arr[1]));
			 
			$index=$this->getIndexIds($explode_line_arr,"Cancel Date",2);	
			$row_data=$explode_line_arr[$index];	
			$date_arr=explode("Cancel Date",$row_data);
			$expired_date=trim(str_ireplace("-","",$date_arr[1]));
			
			$index=$this->getIndexIds($explode_line_arr,"Vendor",2);	
			$row_data=$explode_line_arr[$index];	
			$v_arr=explode("Vendor",$row_data);
			$vendor_code=trim(str_ireplace(":","",$v_arr[1]));
			 $vendor_code_arr=explode("          ",$vendor_code);
			 $vendor_code=$vendor_code_arr[0];
			$this->final_data['po_date']=$this->Addlast2DigitToDate($po_date);
			$this->final_data['delivery_date']=$this->Addlast2DigitToDate($ship_date);
			$this->final_data['expired_date']=$this->Addlast2DigitToDate($expired_date);
			$this->final_data['ship_date']=$this->Addlast2DigitToDate($ship_date);
			$this->final_data['po_site_code']=$vendor_code;
			$this->final_data['po_vendor_code']='';
	 
			
		}
		
		function ConevertToOrderFormat()
		{
		 
			$explode_line_arr=explode("\n",$this->parent_obj->read_txt_data);
			$this->total_po_qty=0;
			$this->total_po_value=0;
			$this->GetPoNumberAndDate($explode_line_arr);
			$this->GetBillingShippingAddress($explode_line_arr);
			$this->GetLineStartAndEndDetails($explode_line_arr);
			$this->GetLineItems($explode_line_arr);
			 //echo "<pre>"; print_r($this->final_data);die();
			return $this->final_data;		
		}
		 
		function GetLineItems($explode_line_arr)
		{ 
		
		$is_igst=$this->getIndexIds($explode_line_arr,"IGST TAX",1);	
		$incr_index=4;
		if($is_igst>1)
		{
			$incr_index=3;
		}
		$o_incr_index=$incr_index;
			/*   echo "<pre>";
			 print_r($this->item_rows_arr);   */
			$this->final_po_items=array();
			$sl_no=0;
			$this->total_po_qty=0;
			$this->total_po_value=0;
			for($i=0;$i<count($this->item_rows_arr);$i+=$incr_index)
			{
			 
			 $incr_index=$o_incr_index;
				$raw_txt=$this->TrimWhiteSpaces($this->item_rows_arr[$i]);
				$hsn_txt=$this->TrimWhiteSpaces($this->item_rows_arr[$i+1]);
				 
				$hsn_arr=explode(" ",$hsn_txt);
				$vat=trim(str_ireplace("%","",$vat_arr[1]));
				
				$item_arr=explode(" ",$raw_txt);
				$r_item_arr=array_reverse($item_arr);	

				$this->final_po_items[$sl_no]['qty']=$this->ReomveCommas($r_item_arr[3]);
				$this->final_po_items[$sl_no]['rate']=$this->ReomveCommas($r_item_arr[6]);
				$this->final_po_items[$sl_no]['po_item_mrp']=$this->ReomveCommas($r_item_arr[7]);
				$this->final_po_items[$sl_no]['uom']= ($r_item_arr[8]);
				$this->final_po_items[$sl_no]['po_item_sku_code']=$item_arr[0];

				$this->final_po_items[$sl_no]['po_item_description']=$this->GetDataTxtFromArrStartToEnd($item_arr,1,count($item_arr)-9);

				$this->final_po_items[$sl_no]['po_item_hsn_code']=	$hsn_arr[0];
				$this->final_po_items[$sl_no]['po_item_barcode']="";
				if($is_igst>1)
				{
					$tax1=$this->GetTaxPerc($this->item_rows_arr[$i+2]);
				 
				}
				else
				{
				$tax1=$this->GetTaxPerc($this->item_rows_arr[$i+2]);
				$tax2=$this->GetTaxPerc($this->item_rows_arr[$i+3]);
				}
				$cgst_found=0;
				$sgst_found=0;
			 
				 if (preg_match("/CGT/", $this->item_rows_arr[$i+2]) || preg_match("/CGST/", $this->item_rows_arr[$i+2]))
					 $cgst_found=1;
				 if (preg_match("/SGT/", $this->item_rows_arr[$i+3]) || preg_match("/SGST/", $this->item_rows_arr[$i+3]))
					 $sgst_found=1;
			 
				 if(empty($is_igst) &&  $sgst_found==0)
				 {
					 $incr_index=$o_incr_index-1;
				 }
				 if($is_igst>1   && (preg_match("/IGT/", $this->item_rows_arr[$i+3]) ))
				 {
					 $tax1+=$this->GetTaxPerc($this->item_rows_arr[$i+3]);
					 $incr_index=$o_incr_index+1;
				 }
				 
				 
				 
				$this->final_po_items[$sl_no]['po_tax_rate']=$tax1+$tax2;	


				$this->final_po_items[$sl_no]['tot_amt']=$this->ReomveCommas($r_item_arr[2]);
			
		
				$this->total_po_qty+=$this->final_po_items[$sl_no]['qty'];
				$this->total_po_value+=$this->final_po_items[$sl_no]['tot_amt'];
				$sl_no++;
					
			}
		 
			$this->final_data['items']=$this->final_po_items;
			$this->final_data['order_qty']=$this->total_po_qty;
			$this->final_data['order_value']=$this->total_po_value;
		   /* 
			     echo "<pre>";
			 print_r($this->final_data);  die(); */
			   
			   return $this->final_data;
			   
			   
		}
		function GetTaxPerc($txt)
		{
			// echo $txt."<br>";
				$txt=trim(str_ireplace("%","",$txt));
			$exp_arr=explode(" ",$txt);
			$exp_arr_rev=array_reverse($exp_arr);
			$tax_perc=$exp_arr_rev[0];
			return $tax_perc;
		}
	function __destruct() {
      unset($this);
    } 
	  
} 
?>