 <?php
ini_set("memory_limit",-1);
ini_set('max_execution_time', 5000);
class excel_parser
{
		public $aobj_context;
 
		function __construct($aobj_context,$parent_obj)
		{
			 
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->parent_obj=$parent_obj;
		$this->user_id = $_SESSION['user_id'];
		$format_file=$aobj_context->main_src."/src/format.php";
		$this->dec_pat="/^[-+]?[0-9]+\.[0-9]{2}+$/";				
		$this->number_pat="/^[0-9]+$/";		
		$this->string_patt="/^[A-Za-z]+$/";	
		$this->GetCustomerIntCode();	
		}
		function TrimWhiteSpaces($text)
		{
		return trim(preg_replace('/\s\s+/', ' ',$text));
		}
		function ReomveCommas($text)
		{
		$txt= trim(preg_replace('/,/', '',$text));
		return $this->TrimWhiteSpaces(trim(preg_replace('/INR/', '',$text)));
		}
		function getIndexIds($explode_line_arr,$name,$start_index)
		{
			for($i=$start_index;$i<count($explode_line_arr);$i++)
			{
			$cell_val=$explode_line_arr[$i];
			 if (preg_match("/{$name}/", $cell_val))
			 return $i;
			}
		}
		function GetFullDateFormat($date)
		{
		return str_ireplace(".","/",$date);
		 	 
		}
		function GetCustomerIntCode()
		{
			$get_data="select internal_code,code,name from customer_master
							where name in ('CloudTail','Amazon')";
			$lobj_get_data = $this->aobj_context->mobj_db->GetAll($get_data);
			foreach($lobj_get_data as $ak=>$av)
			{
			$this->customer_arr[$av['name']]=$av['internal_code'];
			}
			
		 
		}
		 
		
		 
		 
		function GetPoHeaderDetails()
		{
	
				$this->final_data['override_customer_int_code']=$this->customer_arr['CloudTail'];
			$this->final_data['po_number']= $this->excel_formed_sheet_arr[0]['PO'];
			 
		 
			 
			$this->final_data['po_date']= ui_date_Format(GetDbDateFormatFromExcel($this->excel_formed_sheet_arr[0]['Expected Delivery Date']));
			$this->final_data['delivery_date']=	$this->final_data['po_date'];
			$this->final_data['expired_date']=	$this->final_data['po_date'];
			$this->final_data['ship_date']=	$this->final_data['po_date'];
			 
			 $this->final_data['po_vendor_code']=$this->excel_formed_sheet_arr[0]['Vendor'];
			 $this->final_data['ship_to_address']=$this->excel_formed_sheet_arr[0]['Warehouse'];
			$this->final_data['bill_to_address']=$this->excel_formed_sheet_arr[0]['Warehouse'];
		
		 
		}
		
		function ConevertToOrderFormat()
		{
		 
			$this->excel_formed_sheet_arr=array();
			   require_once($this->aobj_context->main_src.'/PHPExcel_1.8.0/Classes/PHPExcel/IOFactory.php');
			$inputFileName=$this->parent_obj->file_src_path;
			$inputFileName=str_ireplace('"','',$inputFileName);
			// $inputFileName="E:\\Tarka-Projects\\gala\\pdfs\\\"a.xlsx\"";
			 
			try 
			{
				$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
				$objReader = PHPExcel_IOFactory::createReader($inputFileType);
				$objPHPExcel = $objReader->load($inputFileName);
				$worksheetList = $objReader->listWorksheetNames($inputFileName);
			}
			catch (Exception $e) 
			{
				$html=('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) 
				. '": ' . $e->getMessage());
				echo $this->aobj_context->mobj_output->ToJSONEnvelope($html,0,"success"); 
				return;
			}
			$sheet = $objPHPExcel->getSheet(0);
			$highestRow = $sheet->getHighestRow();
			$highestColumn = $sheet->getHighestColumn();
			   
			$header_row_arr=$sheet->rangeToArray('A1:' . $highestColumn . 1, NULL, TRUE, FALSE);//take first column values 
			$header_row= $header_row_arr[0];
			$i=0;
			for ($row = 2; $row <= $highestRow; $row++) 
			{
				$rowData_arr = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
				$rowData=$rowData_arr[0];
				foreach($header_row as $hk=>$hv)
					{
					$arr_val=$rowData[$hk];
					trim_array_value($arr_val);
					$this->excel_formed_sheet_arr[$i][$hv]=$arr_val;
					
					}$i++;
			}
			$this->GetPoHeaderDetails();
			$this->GetLineItems();
 	return $this->final_data;
		}
		 
		function GetLineItems($explode_line_arr)
		{ 
			 
		 
			 
			$this->final_po_items=array();
			$sl_no=0;
			$this->total_po_qty=0;
			$this->total_po_value=0;
			
		 
			foreach($this->excel_formed_sheet_arr as $sk=>$sv)
			{
				if(!empty($sv['ASIN']))
				{
					$this->final_po_items[$sl_no]['po_item_description']=$sv['Title'];
					$this->final_po_items[$sl_no]['po_item_sku_code']=$sv['ASIN'];
					$this->final_po_items[$sl_no]['po_item_mrp']=0;
					$this->final_po_items[$sl_no]['po_tax_rate']=0;
					$this->final_po_items[$sl_no]['rate']=$this->ReomveCommas($sv['Unit Cost']);
					 
					 
					$this->final_po_items[$sl_no]['uom']="";
					$this->final_po_items[$sl_no]['qty']=$this->ReomveCommas($sv['Accepted Quantity']);
					$this->final_po_items[$sl_no]['po_item_barcode']=$sv['SKU'];
					 
				 
				
			
					$this->total_po_qty+=$this->final_po_items[$sl_no]['qty'];
					$this->total_po_value+=$this->final_po_items[$sl_no]['qty']*$this->final_po_items[$sl_no]['rate'];
					$sl_no++;
				}
				
				
			}
			
			$this->final_data['items']=$this->final_po_items;
			$this->final_data['order_qty']=$this->total_po_qty;
			$this->final_data['order_value']=$this->total_po_value;
/*  echo "<pre>";
 print_r($this->final_data);die(); */
			   return $this->final_data;
			   
			   
		}
	 
		  
		 
			
		 
			 
			 
		 
	function __destruct() {
      unset($this);
    } 
	  
} 
?>
