<?php
class multipleUploads
{
	function __construct($aobj_context)
	{
		session_start();
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		require_once($this->aobj_context->main_src."/src/json.php");
		require_once($this->aobj_context->main_src."/src/format.php");
	    $this->json = new Services_JSON();
		$this->loggedUserID = $_SESSION['user_id'];
		$this->source_path = $this->GetSourcePath();
	}
	
	function GetSourcePath()
	{
		$get_src_path = "Select pdf_path as source_path from company_setup where 1=1";
		
		$lobj_get_src_path= $this->aobj_context->mobj_db->GetRow($get_src_path);

		return $lobj_get_src_path['source_path'];
	}
	
	function MoveMultipleFilesUpload()
	{
		if(!empty($_FILES))
		{
			$temp_file = $_FILES['file']['tmp_name'];
			$file_name=$_FILES['file']['name'];
			$file_name=preg_replace('/[^A-Za-z0-9\-.]/', '_', $file_name);
			$sp_arr=array("fakepath","c:","d:","e:","f:","C:","D:","E:","F:");
			$file_name=str_ireplace($sp_arr,"_",$file_name);
			$location = $this->source_path."/".$file_name;
			$sucess = move_uploaded_file($temp_file, $location);
			
			echo $sucess;
		}
	}
	
	function DisplayFilesFromServer()
	{
		$this->file_names_arr=array();
		$allowed_extentions=array("png","jpg","jpeg","pdf","docx","doc","xls","xlsx");
		$i=0;				
		if(is_dir($this->source_path)) 
		{		
			
			$files = scandir($this->source_path);
			arsort($files);
			foreach($files as $file)
			{
				$info  =pathinfo($file);
				$extension=strtolower($info['extension']);
				 
				if(in_array($extension,$allowed_extentions) && is_file($this->source_path.'/'.$file)) 
				{
					$this->file_names_arr[$i]['file_name']=$file;
					$this->file_names_arr[$i]['full_path']=$this->source_path.''.$file.'';
					$date = date("d - m - Y H:m:s", filemtime($this->file_names_arr[$i]['full_path']));
					$this->file_names_arr[$i]['date']=$date;
					$i++;
				}
			}
		}
		$s_html="";
		if(count($this->file_names_arr)>0)
		{
			$s_html='<div class="col-md-6 portlet box purple p-l-0 p-r-0" style="margin: 0 auto;">
						<div class="portlet-title">
						<div class="caption">
							Uploaded Files
						</div>
						</div>
						<div class="portlet-body" style="padding:5px;">
							<div class="table-responsive" data-height="300px">
							<table class="table table-hover m-b-0" cellpadding="0" cellspacing="0">
								<thead>
									<tr>											
										<th style="padding: 7px 5px;"><b>Sl No</b></th>
										<th style="padding: 7px 5px;"><b>File Name</b></th>											
										<th style="padding: 7px 5px;"><b>Created Date</b></th>											
										<th style="padding: 7px 5px;"><b>Delete</b></th>
									</tr>
								</thead>
								<tbody>';
			$sl_no=1;					
			foreach($this->file_names_arr as $fk=>$fv)
			{				
				$s_html.="<tr>						
						<td style='padding: 7px 5px;'>{$sl_no}</td>
						<td style='padding: 7px 5px;'><a href='#' onclick='MultipleUploads.ViewFilesFromServer(\"{$fv[file_name]}\");'>{$fv[file_name]}</a></td>									
						<td style='padding: 7px 5px;'>{$fv['date']}</td>					
						<td style='padding: 7px 5px;'><span onclick='MultipleUploads.DeleteFilesFromServer(\"{$fv[file_name]}\");'><i class='fa fa-times' style='color:red; cursor:pointer; padding:4px; font-size:12pt'></i></span></td>					
						</tr>";	
				$sl_no++;		
			}						
			$s_html.='</tbody></table>
						</div>
					</div>
					</div>';		
		}
		else
		{
			$s_html="<p style='text-align:center; color:red;'>No more files found in the location!</p>";	
		}
		echo $this->aobj_context->mobj_output->ToJSONEnvelope($s_html,0,"success"); 			
	}
	
	function ViewFilesFromServer()
	{
		$path = $this->source_path;
		$file_name = $this->aobj_context->mobj_data["file_name"];
		$path = $this->source_path.$file_name;
		$len = filesize($path);
		$file_ext=basename($path);
		$file_name=basename($path);
		$file_ext_arr=explode(".",$file_ext);
		$file_ext=strtolower($file_ext_arr[count($file_ext_arr)-1]);
		switch( $file_ext ) {
			case "pdf": $ctype="application/pdf"; break;
			case "exe": $ctype="application/octet-stream"; break;
			case "zip": $ctype="application/zip"; break;
			case "doc": $ctype="application/msword"; break;
			case "txt": $ctype="application/txt"; break;
			case "php": $ctype="application/php"; break;
			case "htm": $ctype="application/htm"; break;
			case "html": $ctype="application/html"; break;
			case "xls": $ctype="application/vnd.ms-excel"; break;
			case "ppt": $ctype="application/vnd.ms-powerpoint"; break;
			case "gif": $ctype="image/gif"; break;
			case "png": $ctype="image/png"; break;
			case "jpeg":
			case "jpg": $ctype="image/jpg"; break;
			case "mp3": $ctype="audio/mpeg"; break;
			case "wav": $ctype="audio/x-wav"; break;
			case "mpeg":
			case "mpg":
			case "mpe": $ctype="video/mpeg"; break;
			case "mov": $ctype="video/quicktime"; break;
			case "avi": $ctype="video/x-msvideo"; break;
			//The following are for extensions that shouldn't be downloaded (sensitive stuff, like php files)
			case "phpa":
			case "htma":
			case "htmla":
			die("<b>Cannot be used for ". $file_extension ." files!</b>"); break;
			default: $ctype="application/force-download";
		}
		header("Pragma: public");
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Cache-Control: public"); 
		header("Content-Description: File Transfer");
		header("Content-Type: $ctype");
		$header="Content-Disposition: attachment; filename=".$file_name.";";
		header($header);
		header("Content-Transfer-Encoding: binary");
		header("Content-Length: ".$len);
		readfile($path);
	}
	
	function DeleteFilesFromServer()
	{
		$file_name=$this->aobj_context->mobj_data['file_name'];	
		$root_file_name=$this->source_path.$file_name;		   
		if(!empty($root_file_name))
		{
			unlink($root_file_name);
			$rdata="Deleted successfully!";
			echo $this->aobj_context->mobj_output->ToJSONEnvelope($rdata,0,"success");
			return;
		}
		else
		{
			$rdata="Deletion failed!";
			echo $this->aobj_context->mobj_output->ToJSONEnvelope($rdata,0,"success");
			return;
		}		   
	}
}
function MoveMultipleFilesUpload($aobj_context)
{
	$dash_obj = new multipleUploads($aobj_context);		
	$dash_obj->MoveMultipleFilesUpload();
}
function DisplayFilesFromServer($aobj_context)
{
	$dash_obj = new multipleUploads($aobj_context);		
	$dash_obj->DisplayFilesFromServer();
}
function ViewFilesFromServer($aobj_context)
{
	$dash_obj = new multipleUploads($aobj_context);		
	$dash_obj->ViewFilesFromServer();
}
function DeleteFilesFromServer($aobj_context)
{
	$dash_obj = new multipleUploads($aobj_context);		
	$dash_obj->DeleteFilesFromServer();
}
?>