<?PHP
date_default_timezone_set('Asia/Calcutta');
session_start();
class packing_list_report
 {
    public $aobj_context;
    function __construct($aobj_context,$po_number,$send_mail,$call_type="UI",$save_type="Single",$dir_path)
	{ 
		$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->aobj_context=$aobj_context;
		$this->login_ctr = $_SESSION['login_cnt'];	
		$this->user_type = $_SESSION['user_type'];
		require_once($this->aobj_context->main_src."/src/report_class.php");
	 
		
		require_once($this->aobj_context->main_src."/custom_src/common_data.php");
		$this->comm_obj = new common_data($this->aobj_context);
		$format_file=$aobj_context->main_src."/src/format.php";
		require_once($format_file);
		require_once($aobj_context->main_src."/src/getnumword.php");
		require_once($aobj_context->main_src."/src/cManualMailer.php");
		$this->schema_name = $aobj_context->mobj_data["schema_name"];	
		$this->report_id = $aobj_context->mobj_data["report_id"];				
		$this->report_type = $aobj_context->mobj_data["report_type"];				
		$this->save_type = $save_type;	
		$this->po_number = $po_number;	
		$this->call_type = $call_type;	
		$this->send_mail = $send_mail;	
		$this->dir_path=$dir_path;
		
	}
	
	
	function CreateExcelObject()
	{
		$this->Excel = new create_report($this->aobj_context);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setTop(0.3);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setRight(0.2);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setLeft(0.5);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setBottom(0);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setHeader(1);
		$this->Excel->objPHPExcel->getActiveSheet()->getPageMargins()->setFooter(0);
		
		
		
		$this->Excel->HideGridLines();	
		// $this->Excel->setScale(60);
		$col=0 ;
		
	
		$this->Excel->SetColumnWidthManual(0,32);
		$this->Excel->SetColumnWidthManual(1,10);
		$this->Excel->SetColumnWidthManual(2,10);
		$this->Excel->SetColumnWidthManual(3,10);
		$this->Excel->SetColumnWidthManual(4,10);
		$this->Excel->SetColumnWidthManual(5,11);
		$this->Excel->SetColumnWidthManual(6,15);
		$this->Excel->SetColumnWidthManual(7,10);
		$this->Excel->SetColumnWidthManual(8,10);
		$this->Excel->FitTopage();
	  
		
		$get_item_details="select DATE_FORMAT(po.po_date,'%d/%m/%Y') as date,po.po_number as number,packing_list_mail_id,
					pog.qty,am.stock_description,am.stock_code,am.pack_qty,am.uom,
					bcm.customer_code,bcm.customer_name,  CONCAT(IFNULL(address_1,''),' ',IFNULL(address_2,'')) as add1,concat(IFNULL(address_3,''),' ',IFNULL(address_4,''),' ',IFNULL(address_5,''),' ') as add2
					from purchase_order po
					inner join bill_to_customer_master bcm 
					on bcm.internal_code = po.bill_to
					inner join purchase_order_item_group pog ON pog.ref_s_ref_data_code=po.internal_code
					inner join status s on s.internal_code=po.status
					and s.status='Order'
					inner join article_master am ON am.internal_code = pog.item
					where po.internal_code = {$this->po_number}
					and ifnull(pog.ignore_for_xlite,'No')='No' ";
		$this->get_item_details=$this->aobj_context->mobj_db->GetAll($get_item_details);
		$this->date=$this->get_item_details[0]['date'];
		$this->packing_list_mail_id=$this->get_item_details[0]['packing_list_mail_id'];
		$this->number=$this->get_item_details[0]['number'];
		$this->customer_code=$this->get_item_details[0]['customer_code'];
		$this->customer_name=$this->get_item_details[0]['customer_name'];
		$this->add1=$this->get_item_details[0]['add1'];
		$this->add2=$this->get_item_details[0]['add2'];
		//echo $get_item_details;die();
		
		$this->file_name=$this->customer_code."_".$this->number.".xlsx";
		$this->row=1;
		$this->Excel->WriteCellNew($this->row,0,"Order No : ".' '.$this->number,"Title_Left","");
		$this->Excel->WriteCellNew($this->row,1,"Order Date : ".' '.$this->date,"Title_Left","");
		$this->row++;
		$this->Excel->WriteCellNew($this->row,0,"Customer : ".' '.$this->customer_code."-".$this->customer_name,"Title_Left","");
		$this->row++;
		$this->Excel->WriteCellNew($this->row,0,"Address : ".' '.$this->add1,"Title_Left","");
		$this->row++;
		$this->Excel->WriteCellNew($this->row,0,"                  ".' '.$this->add2,"Title_Left","");
		$this->row++;
		$this->Excel->WriteCellNew($this->row,0,"Item Name","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,1,"SAP Code","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,2,"Customer Pack Size.","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,3,"No Of Cartons.","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,4,"Order Qty","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,5,"Dispatched Qty","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,6,"Carton Number","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,7,"Pipe Master No.","Title_Center_Border","");
		$this->Excel->WriteCellNew($this->row,8,"CTNS","Title_Center_Border","");
		$this->row++;
		foreach($this->get_item_details as $k => $v)
		{
		  $uom=$v['uom'];
		  $this->Excel->SetRowHeight($this->row,31);
		  $this->Excel->WriteCellNew($this->row,0,$v['stock_description'],"Data_Left","");
		  $this->Excel->WriteCellNew($this->row,1,$v['stock_code'],"Data_Right","");
		  $this->Excel->WriteCellNew($this->row,2,$v['pack_qty'],"Data_Right","");
		  $po_qty=$v['qty'];
		 
		  $pack_qty=$v['pack_qty'];
		  // echo $v['stock_description']."-------".$uom."<br>";
		  if($uom=="EA")
		  {
			  $no_of_cottons=$po_qty/$pack_qty;
			  $excel_order_qty=$po_qty;
		  }
		  else
		  {		$no_of_cottons=$po_qty;
			    $excel_order_qty=$po_qty*$pack_qty;
			    
		  }
		  $this->Excel->WriteCellNew($this->row,3,$no_of_cottons,"Data_Center","");
		  $this->Excel->WriteCellNew($this->row,4,$excel_order_qty,"Data_Center","");
		   
		  $this->Excel->WriteCellNew($this->row,6,"","Data_Center","");
		  $this->Excel->WriteCellNew($this->row,7,"","Data_Center","");
		  $this->Excel->WriteCellNew($this->row,8,"","Data_Center","");
		  $this->row++;
		}
		
		$highestColumm = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestColumn(); // e.g. "EL" 
		$highestRow = $this->Excel->objPHPExcel->setActiveSheetIndex(0)->getHighestRow(); 
		$range="A5:{$highestColumm}{$highestRow}";
		$this->Excel->objPHPExcel->getActiveSheet()->getStyle($range)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);	
		$font = array(
				'font'  => array(
					  'size'  => '12',
					'name'  => 'Cambria'
				));
			$this->Excel->objPHPExcel->getActiveSheet()->getStyle("A6:{$highestColumm}{$highestRow}")->applyFromArray($font);
		
	   
	}
	
	
	function SendOutput()
	{
		 
		$this->Excel->objPHPExcel->setActiveSheetIndex(0);
		// echo $this->save_type.'--'.$this->send_mail;die();
		if($this->save_type=="Multiple")
		{
			$path=$this->dir_path."/".$this->file_name;
			$this->Excel->WritePhysicalExcel($path,$this->file_name);
			
		}
		else if($this->send_mail=="Yes")
		{
			$path=$this->aobj_context->main_src."/imported_files/".$this->file_name;
			$this->Excel->WritePhysicalExcel($path,$this->file_name);
			
			$to=$this->packing_list_mail_id;
			$to="swagatam.gupta@fhp-ww.com";
			$subject="Packing List from Leap";
			$message=" Please find the attached Packing List";
			$cc="";
			$attachment_arr[0][path]=$path;
			$attachment_arr[0][name]=$this->file_name;
		    $response=send_manual_mail($this->aobj_context,$to,$subject,$message,$cc,$attachment_arr);
			if($this->call_type=="UI")
				echo $response;
			
		}
		else
		$this->Excel->SendOutput();
	}
}  	
function downloadReport($aobj_context)
{ 
	$format_file=$aobj_context->main_src."/src/format.php";
	require_once($format_file);
	$aobj_context->mobj_db->SetFetchMode(ADODB_FETCH_ASSOC);
	$po_number = $aobj_context->mobj_data["po_number"];	
	$send_mail = $aobj_context->mobj_data["send_mail"];	
	$customer = $aobj_context->mobj_data["customer"];	
	$from_date = db_date_format($aobj_context->mobj_data["from_date"]);
	$to_date = db_date_format($aobj_context->mobj_data["to_date"]);
	$time=date('h_i_s');;
	if(empty ($po_number))
	{
		
		$dir_path=$aobj_context->main_src."/imported_files/packing_list_{$_SESSION['login_cnt']}_{$time}";
		rmdir($dir_path);
		mkdir($dir_path);
	  $get_details="select po.internal_code
					from purchase_order po
					inner join status s on s.internal_code=po.status and s.status='Order'
					where po.customer ={$customer} and  po.date  between '{$from_date}' and '{$to_date}'";
		$objget_details=$aobj_context->mobj_db->GetAll($get_details);
		//echo $get_details;die();
		foreach($objget_details  as $kk => $vv)
		{
			$po_number=$vv[internal_code];
		  $obj=new packing_list_report($aobj_context,$po_number,$send_mail,"UI","Multiple",$dir_path); 
		$obj->CreateExcelObject();	
		$obj->SendOutput(); 		  
		  unset($obj);
		
		}
			 $easy_zip_file_path=$aobj_context->main_src."/easy_zip/easy_zip.php";
			require_once($easy_zip_file_path);
	
			$zipobj = new EasyZIP;
			$zipobj -> addDir($dir_path);
			$zipobj -> zipFile("{$dir_path}.zip");	 
			header("Expires: 0");
			header("Content-type: application/zip");
			header("Content-Disposition: attachment; filename=packing_list.zip");
			
			print file_get_contents($dir_path.".zip");
			rmdir($dir_path);
			 unlink($dir_path.".zip"); 
	}
	else 
	{
	$obj=new packing_list_report($aobj_context,$po_number,$send_mail,"UI","Singe",$dir_path); 
	$obj->CreateExcelObject();	
		$obj->SendOutput(); 	
	}
    
}
?>